<?php

session_start();

//Pārbauda, vai nav iegūts grāmatas id
if (!isset($_GET['id'])) {
    //Ja nav, tad tiek izvadīta kļūda
    http_response_code(400); 
    echo "Grāmatas ID ir pazudis";
    exit; 
}

require __DIR__ . "/../db/database.php";

$bookId = $_GET['id'];

// Pārbauda, vai grāmatas id nav skaitlis
if (!is_numeric($bookId)) {
    // Ja nav, tad izvada kļūdu
    http_response_code(400); 
    echo "Nepareizs grāmatas ID";
    exit; 
}

// Pieprasījums, kas iegūst grāmatas bildi pēc id
$sql = "SELECT image FROM books WHERE id = ?";
$stmt = $mysqli->prepare($sql);
$stmt->bind_param("i", $bookId);
$stmt->execute();
$stmt->bind_result($image);
$stmt->fetch();
$stmt->close();

// Pārbauda, vai ir bilde dotajai grāmatai
if ($image) {
    // Ja ir, tiek iegūta bildes vieta
    $imagePath = "../uploads/" . $image;

    // Pārbauda, vai fails eksistē
    if (file_exists($imagePath)) {
        // Ja eksistē, izdzēš bildi no failiem
        unlink($imagePath);
        echo "Bilde ir veiksmīgi izdzēsta.";
    } else {
        echo "Bilde nav atrasta.";
    }
} else {
    echo "Nav bildes dotajai grāmatai.";
}

// Pieprasījums, kas izdzēš visas atsauksmes pēc grāmatas id, lai nerastos kļūdas. 
$sql = "DELETE FROM reviews WHERE id_book = ?";
$stmt = $mysqli->prepare($sql);
$stmt->bind_param("i", $bookId);
$result = $stmt->execute();

// Pieprasījums, kas izdzēš grāmatu pēc id
$sql = "DELETE FROM books WHERE id = ?";
$stmt = $mysqli->prepare($sql);
$stmt->bind_param("i", $bookId);
$result = $stmt->execute();

// Pārbauda, vai ir iegūts rezultāts
if ($result) {
    // Ja ir, paziņo par grāmatas veiksmīgu izdzēšanu
    http_response_code(200); 
    echo "Grāmata ir veiksmīgi izdzēsta";
} else {
    // Ja nav, izvada kļūdu
    http_response_code(500); 
    echo "Neizdevās izdzēst grāmatu";
}


$stmt->close();
$mysqli->close();
